NVSMSG ;slcciofo/maw,mb-alert and messaging utility ;02:21 PM  19 Apr 2000
 ;;2.0;NVS system management utility;**11,12,13**; Jan 01, 1999
 ;
 ; **NOTE: THIS ROUTINE IS USED ONLY ON INTERSYSTEMS CACHE SYSTEMS**
 ;
 ; This routine is invoked by various NVS system monitoring utilities
 ; (for example, unattended backup, integrity check, etc.).  It retrieves
 ; the contents of the host file specified and places it in a mail message.
 ; For Intersystems Cache, a CSTAT can be generated by this utility (see
 ; further documentation below).  If warranted, an alert can also be set
 ; up by this utility (see documentation below).
 ;
EN(DIR,FILE,SUBJ,ALERT,CSTAT)   ;
 ;
 ; DIR   = the directory path where FILE will be found.
 ;         If DIR is passed = "", this module aborts.
 ; FILE  = the name of the host file to be retrieved and
 ;            included in the mail message.
 ; SUBJ  = a string (up to 30 characters) that will be used
 ;            as the message (and alert, if appropriate) subject.
 ;            Note:  SUBJ will be truncated if $LENGTH>30
 ; ALERT = pass = 1 if an alert is to be sent
 ; CSTAT = pass = 1 and a CSTAT will be generated
 ;
 N DEVOK,ERRFLAG,I,LINENUM,MAILGRP,MSGNUM
 S $ZT=$G(^%ZOSF("ERRTN"))
 S U="^"
 K ^TMP($J),^XTMP("NVSMSG")
 I $G(SUBJ)="" S SUBJ="NVS SYSTEM PROCEDURE MESSAGE"
 I $L(SUBJ)>30 S SUBJ=$E(SUBJ,1,30)
 I FILE=""&(DIR'="") D
 .I $ZV["OpenVMS" D  Q
 ..I DIR[":"&(DIR'["]") D  Q
 ...S FILE=$P(DIR,":",2)
 ...S DIR=$P(DIR,":")_":"
 ..I DIR["]" D  Q
 ...S FILE=$P(DIR,"]",2)
 ...S DIR=$P(DIR,"]")_"]"
 .I $ZV["Windows" D
 ..S DIR=$TR(DIR,"/","\")
 ..F I=1:1 Q:$P(DIR,"\",I)=""
 ..S FILE=$P(DIR,"\",I-1)
 ..S DIR=$P(DIR,FILE)
 S ALERT=+ALERT
 S CSTAT=+CSTAT
 ;
 I DIR=""!(FILE="") D  Q
 .S ^TMP($J,1)="An error occured during a system procedure."
 .S ^TMP($J,2)="No log file was specified.  Following is the"
 .S ^TMP($J,3)="information that was provided by the calling"
 .S ^TMP($J,4)="application:"
 .S ^TMP($J,5)="  Host file directory: "_$S($G(DIR)'="":DIR,1:"not specified")
 .S ^TMP($J,6)="  Host file name: "_$S($G(FILE)'="":FILE,1:"not specified")
 .S ^TMP($J,7)="  Subject: "_$S($G(SUBJ)'="":SUBJ,1:"not specified")
 .S ^TMP($J,8)="No other information is available.  Please investigate."
 .S MAILGRP=""
 .I $$GROUP("IRM") S MAILGRP="G.IRM"
 .I MAILGRP="" S MAILGRP=.5
 .S MSGNUM=0
 .D MAIL(SUBJ,MAILGRP,"^TMP("_$J_",",+$G(ALERT),.MSGNUM)
 ;
 S ^XTMP("NVSMSG",0)=$$DT^XLFDT_U_$$DT^XLFDT_U_"NVS Procedure Message"
 ;
 ; call Kernel to retrieve the log file contents and set the temporary
 ; global for us...
 S DEVOK=1
 S DEVOK=$$FTG^%ZISH(DIR,FILE,"^XTMP(""NVSMSG"",1)",2,"OVF")
 ;
 ; if DEVOK is 0, then the log file couldn't be retrieved, or the
 ; temporary global array could not be set.  Set up the message to
 ; relay this information...
 I 'DEVOK D
 .S ^TMP($J,1)="An error occured attempting to retrieve a specified host"
 .S ^TMP($J,2)="file during a system process.  Here is the information"
 .S ^TMP($J,3)="specified by the calling utility:"
 .S ^TMP($J,4)="Directory: "_$S(DIR'="":DIR,1:"not specified")
 .S ^TMP($J,5)="File name: "_$S(FILE'="":FILE,1:"not specified")
 .S ^TMP($J,6)="Subject: "_$S(SUBJ'="":SUBJ,1:"not specified")
 ;
 ; retrieve the text from the temporary global and put into our local array...
 I DEVOK D
 .S (ERRFLAG,LINENUM)=0
 .F  S LINENUM=$O(^XTMP("NVSMSG",LINENUM)) Q:'LINENUM!(ERRFLAG=1)  D
 ..S ^TMP($J,LINENUM)=^XTMP("NVSMSG",LINENUM)
 ..I ^TMP($J,LINENUM)["WARNING"!(^TMP($J,LINENUM)["$ZE") S ERRFLAG=1
 .;
 .; check for ERRFLAG.  if it = 1, then warnings and/or errors exist in
 .; the log file.  let's insert a line right at the top of the message text
 .; indicating that fact...
 .I +$G(ERRFLAG) D
 ..S ^TMP($J,.1)="**********************>> WARNING <<***********************"
 ..S ^TMP($J,.2)="* ERROR AND/OR WARNING MESSAGES EXIST IN THIS LOG FILE!! *"
 ..S ^TMP($J,.3)="* RECOMMEND COMPLETE REVIEW OF THE LOG FILE AND          *"
 ..S ^TMP($J,.4)="* CORRECTIVE ACTION BE TAKEN IMMEDIATELY!!               *"
 ..S ^TMP($J,.5)="**********************************************************"
 .;
 .; if CSTAT, generate one and tell the recipients that we did that...
 .I +$G(CSTAT) D
 ..I $ZV["OpenVMS" S X=$ZF(-1,"@SYS$COMMON:[SYSMGR]CSTAT.COM")
 ..I $ZV["Windows NT" S X=$ZF(-1,"T:\ANONYMOUS\CSTAT\CSTAT.CMD")
 ..S ^TMP($J,.6)=" "
 ..S ^TMP($J,.7)="NOTE!! THE CSTAT COMMAND FILE WAS CALLED AS A RESULT OF THIS PROBLEM."
 ..S ^TMP($J,.8)="Please look for the CSTAT reports in "
 ..I $ZV["OpenVMS" S ^TMP($J,.8)=^TMP($J,.8)_"USER$:[ANONYMOUS.CSTAT]"
 ..I $ZV["Windows NT" S ^TMP($J,.8)=^TMP($J,.8)_"T:\ANONYMOUS\CSTAT\"
 ..S ^TMP($J,.9)=" "
 ;
 ; send the mail message.  NOTE:  site can change the mail group to be looked
 ; up ("IRM" is the default) by changing the mail group name in the following...
 S MAILGRP=""
 I $$GROUP("IRM") S MAILGRP="G.IRM"
 I MAILGRP="" S MAILGRP=.5
 S MSGNUM=0
 D MAIL(SUBJ,MAILGRP,"^TMP("_$J_",",+$G(ALERT),.MSGNUM)
 ;
 ; if ALERT requested *and* message recipient is not POSTMASTER, set up the alert...
 I +$G(ALERT)&(+MAILGRP'=.5) D ALERT(SUBJ_" Check mail message "_MSGNUM_".",MAILGRP)
 ;
 K ^TMP($J),^XTMP("NVSMSG")
 Q
 ;        
MAIL(MSGSUBJ,RECIP,TEXT,NVS,MSG)        ; send e-mail...
 ; MSGSUBJ = message subject
 ; RECIP   = mail group name (local and/or remote) or local user DUZ
 ; TEXT    = local or global array reference for the text to be included in the message.
 ;           Note:  this reference must be in the form required by ^XMD -- for example:
 ;             TEXT="array("
 ;             TEXT="^TMP($J,"
 ; NVS     = if passed=1 then mail group G.CSAVANTI@FORUM.MED.VA.GOV added to recipients
 ; MSG     = passed by reference, returned as the message number (XMZ)
 ;
 N XMDUZ,XMSUB,XMTEXT,XMY,XMZ,XTEXT
 S XMDUZ=.5
 S XMSUB=MSGSUBJ
 S XMY(RECIP)=""
 I +$G(NVS)=1 S XMY("G.CSAVANTI@FORUM.MED.VA.GOV")=""
 I TEXT'="" S XMTEXT=TEXT
 I TEXT="" D
 .S XTEXT(1)="NO TEXT WAS DEFINED FOR THIS MESSAGE"
 .S XMTEXT="XTEXT("
 D ^XMD
 S MSG=XMZ
 Q
 ;
ALERT(ASUBJ,RECIP)      ; send a simple alert...
 ; ASUBJ = alert subject (can be same as mail message subject)
 ; RECIP = an individual local user or mail group to which the alert will be sent
 ;
 N DUZ,XQA,XQAID,XQAMSG
 S DUZ=".5"
 S XQA(RECIP)=""
 S XQAID="NVS"_$J
 S XQAMSG=ASUBJ
 D SETUP^XQALERT
 Q
 ;
GROUP(X)        ; verify a specified mail group exists and that it has membership...
 ; X = name of mail group (example: "IRM")
 ; returns 0 if not found, 1 if found
 N Y
 S Y=+$O(^XMB(3.8,"B",X,0))
 I Y'>0 Q 0
 ; check for members in this group...
 I $O(^XMB(3.8,Y,1,"B",""))="" Q 0
 Q 1
